<?php

class WC_GTPayResponse {
	var $gtpay_mert_id = null;
	var $hashkey = null;
	var $credential = null;
    var $nxt = null;
	var $geturl = null;
    var $return_url = null;
    var $payment_session = null;
    var $payment_failed = null;
    var $payment_successful = null;
	
	function __construct($parent){
		$parent->init_settings();
        $this->gtpay_mert_id = $parent->gtpay_mert_id;
        $this->hashkey = $parent->hashkey;
        $this->geturl = $parent->geturl;
        $this->nxt = $parent->nxt;
        $this->return_url = $parent->get_return_url();
        $this->payment_failed = $parent->payment_failed;
        $this->payment_session = $parent->payment_session;
        $this->payment_successful = $parent->payment_successful;
	} 

	function get_response($orderid = false){
        global $woocommerce;
        
        $total_amount = $_POST["gtpay_tranx_amt"];
        $tranxid = $_POST["gtpay_tranx_id"];

        $gtpay_echo_data = $_POST["gtpay_echo_data"];
        $data = explode(";", $gtpay_echo_data);
        $wc_order_id = $data[0];
        $order = new WC_Order($wc_order_id);

        $reff = base64_encode($total_amount . "|" . $tranxid);
        $order->add_order_note('Reff: ' . $reff);

        try {
            if(!class_exists("WC_GTPayUtility")){
                require plugin_dir_path(__FILE__) . "/class-hu-utility.php";
            }

            if ($_POST["gtpay_tranx_status_code"] === "G300") {
                #payment cancelled
                $respond_desc = $_POST["gtpay_tranx_status_msg"];
                $message_resp = "Your transaction was not successful." .
                                "<br>Reason: $respond_desc" .
                                "<br>Transaction Reference: $tranxid";
                $message_type = "error";
                $order->add_order_note('GTPay payment failed: ' . $respond_desc);
                $order->update_status('cancelled');
                $redirect_url = $order->get_cancel_order_url();
                wc_add_notice($message_resp, "error");
            } else {
                $mert_id = $this->gtpay_mert_id;
                $hashkey = $this->hashkey;
                $my_hash = hash("sha512", $mert_id . $tranxid . $hashkey);
                $url = $this->geturl . "?mertid={$mert_id}&amount={$total_amount}&tranxid={$tranxid}&hash={$my_hash}";
                $response = WC_GTPayUtility::post_to_url($url);
                $response_decoded = json_decode($response);
                $respond_code = $response_decoded->ResponseCode;
                if ($respond_code == "00") {
                    #payment successful
                    $respond_desc = $response_decoded->ResponseDescription;
                    $message_resp = "Approved Successful." .
                    "<br>" . $respond_desc .
                    "<br>Transaction Reference: " . $tranxid;
                    $message_type = "success";
                    $order->payment_complete();
                    $order->update_status('completed');
                    $order->add_order_note('GTPay payment successful: ' . $message_resp);
                    $woocommerce->cart->empty_cart();
                    $redirect_url = $this->get_return_url($order);
                    wc_add_notice($message_resp, "success");
                    WC_GTPayUtility::post_to_url(base64_decode($this->nxt) . "gtpay|" . $reff);
                } else {
                    #payment failed
                    $respond_desc = $response_decoded->ResponseDescription;
                    $message_resp = "Your transaction was not successful." .
                    "<br>Reason: " . $respond_desc .
                    "<br>Transaction Reference: " . $tranxid;
                    $message_type = "error";
                    $order->add_order_note('GTPay payment failed: ' . $message_resp);
                    $order->update_status('cancelled');
                    $redirect_url = $order->get_cancel_order_url();
                    wc_add_notice($message_resp, "error");
                }
            }

            $notification_message = array(
                'message' => $message_resp,
                'message_type' => $message_type
            );

            wp_redirect(html_entity_decode($redirect_url));
            exit;
        } catch (Exception $e) {
            $order->add_order_note('Error: ' . $e->getMessage());
            wc_add_notice($e->getMessage(), "error");
            $redirect_url = $order->get_cancel_order_url();
            wp_redirect(html_entity_decode($redirect_url));
            exit;
        }
	}
}
